/*
 * Decompiled with CFR 0.152.
 */
package javax.print;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Vector;

class MimeType
implements Serializable,
Cloneable {
    private String[] myPieces;
    private transient String myStringValue = null;
    private transient ParameterMapEntrySet myEntrySet = null;
    private transient ParameterMap myParameterMap = null;
    private static final int TOKEN_LEXEME = 0;
    private static final int QUOTED_STRING_LEXEME = 1;
    private static final int TSPECIAL_LEXEME = 2;
    private static final int EOF_LEXEME = 3;
    private static final int ILLEGAL_LEXEME = 4;

    public int hashCode() {
        return this.getStringValue().hashCode();
    }

    public boolean equals(Object object) {
        return object != null && object instanceof MimeType && this.getStringValue().equals(((MimeType)object).getStringValue());
    }

    public String getMediaSubtype() {
        return this.myPieces[1];
    }

    public String getMediaType() {
        return this.myPieces[0];
    }

    public String getMimeType() {
        return this.getStringValue();
    }

    private String getStringValue() {
        if (this.myStringValue == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.myPieces[0]);
            stringBuffer.append('/');
            stringBuffer.append(this.myPieces[1]);
            int n2 = this.myPieces.length;
            for (int i2 = 2; i2 < n2; i2 += 2) {
                stringBuffer.append(';');
                stringBuffer.append(' ');
                stringBuffer.append(this.myPieces[i2]);
                stringBuffer.append('=');
                stringBuffer.append(MimeType.addQuotes(this.myPieces[i2 + 1]));
            }
            this.myStringValue = stringBuffer.toString();
        }
        return this.myStringValue;
    }

    public String toString() {
        return this.getStringValue();
    }

    public MimeType(String string) {
        this.parse(string);
    }

    private void parse(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        LexicalAnalyzer lexicalAnalyzer = new LexicalAnalyzer(string);
        Vector vector = new Vector();
        boolean bl2 = false;
        boolean bl3 = false;
        if (lexicalAnalyzer.getLexemeType() != 0) {
            throw new IllegalArgumentException();
        }
        String string2 = MimeType.toUnicodeLowerCase(lexicalAnalyzer.getLexeme());
        vector.add(string2);
        lexicalAnalyzer.nextLexeme();
        bl2 = string2.equals("text");
        if (lexicalAnalyzer.getLexemeType() != 2 || lexicalAnalyzer.getLexemeFirstCharacter() != '/') {
            throw new IllegalArgumentException();
        }
        lexicalAnalyzer.nextLexeme();
        if (lexicalAnalyzer.getLexemeType() == 0) {
            vector.add(MimeType.toUnicodeLowerCase(lexicalAnalyzer.getLexeme()));
            lexicalAnalyzer.nextLexeme();
        } else {
            throw new IllegalArgumentException();
        }
        while (lexicalAnalyzer.getLexemeType() == 2 && lexicalAnalyzer.getLexemeFirstCharacter() == ';') {
            lexicalAnalyzer.nextLexeme();
            if (lexicalAnalyzer.getLexemeType() != 0) {
                throw new IllegalArgumentException();
            }
            string2 = MimeType.toUnicodeLowerCase(lexicalAnalyzer.getLexeme());
            vector.add(string2);
            lexicalAnalyzer.nextLexeme();
            bl3 = string2.equals("charset");
            if (lexicalAnalyzer.getLexemeType() != 2 || lexicalAnalyzer.getLexemeFirstCharacter() != '=') {
                throw new IllegalArgumentException();
            }
            lexicalAnalyzer.nextLexeme();
            if (lexicalAnalyzer.getLexemeType() == 0) {
                string2 = lexicalAnalyzer.getLexeme();
                vector.add(bl2 && bl3 ? MimeType.toUnicodeLowerCase(string2) : string2);
                lexicalAnalyzer.nextLexeme();
                continue;
            }
            if (lexicalAnalyzer.getLexemeType() == 1) {
                string2 = MimeType.removeBackslashes(lexicalAnalyzer.getLexeme());
                vector.add(bl2 && bl3 ? MimeType.toUnicodeLowerCase(string2) : string2);
                lexicalAnalyzer.nextLexeme();
                continue;
            }
            throw new IllegalArgumentException();
        }
        if (lexicalAnalyzer.getLexemeType() != 3) {
            throw new IllegalArgumentException();
        }
        int n2 = vector.size();
        this.myPieces = (String[])vector.toArray(new String[n2]);
        for (int i2 = 4; i2 < n2; i2 += 2) {
            int n3;
            for (n3 = 2; n3 < i2 && this.myPieces[n3].compareTo(this.myPieces[i2]) <= 0; n3 += 2) {
            }
            while (n3 < i2) {
                String string3 = this.myPieces[n3];
                this.myPieces[n3] = this.myPieces[i2];
                this.myPieces[i2] = string3;
                string3 = this.myPieces[n3 + 1];
                this.myPieces[n3 + 1] = this.myPieces[i2 + 1];
                this.myPieces[i2 + 1] = string3;
                n3 += 2;
            }
        }
    }

    public Map getParameterMap() {
        if (this.myParameterMap == null) {
            this.myParameterMap = new ParameterMap(this, null);
        }
        return this.myParameterMap;
    }

    private static String addQuotes(String string) {
        int n2 = string.length();
        StringBuffer stringBuffer = new StringBuffer(n2 + 2);
        stringBuffer.append('\"');
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '\"') {
                stringBuffer.append('\\');
            }
            stringBuffer.append(c2);
        }
        stringBuffer.append('\"');
        return stringBuffer.toString();
    }

    private static String removeBackslashes(String string) {
        int n2 = string.length();
        char[] cArray = new char[n2];
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '\\') {
                c2 = string.charAt(++i2);
            }
            cArray[n3++] = c2;
        }
        return new String(cArray, 0, n3);
    }

    private static String toUnicodeLowerCase(String string) {
        int n2 = string.length();
        char[] cArray = new char[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            cArray[i2] = Character.toLowerCase(string.charAt(i2));
        }
        return new String(cArray);
    }

    static String[] access$000(MimeType mimeType) {
        return mimeType.myPieces;
    }

    static ParameterMapEntrySet access$200(MimeType mimeType) {
        return mimeType.myEntrySet;
    }

    static ParameterMapEntrySet access$202(MimeType mimeType, ParameterMapEntrySet parameterMapEntrySet) {
        mimeType.myEntrySet = parameterMapEntrySet;
        return mimeType.myEntrySet;
    }

    static class 1 {
    }

    private static class LexicalAnalyzer {
        protected String mySource;
        protected int mySourceLength;
        protected int myCurrentIndex;
        protected int myLexemeType;
        protected int myLexemeBeginIndex;
        protected int myLexemeEndIndex;

        public char getLexemeFirstCharacter() {
            return this.myLexemeBeginIndex >= this.mySourceLength ? (char)'\u0000' : this.mySource.charAt(this.myLexemeBeginIndex);
        }

        public int getLexemeType() {
            return this.myLexemeType;
        }

        public void nextLexeme() {
            int n2 = 0;
            int n3 = 0;
            while (n2 >= 0) {
                switch (n2) {
                    case 0: {
                        char c2;
                        if (this.myCurrentIndex >= this.mySourceLength) {
                            this.myLexemeType = 3;
                            this.myLexemeBeginIndex = this.mySourceLength;
                            this.myLexemeEndIndex = this.mySourceLength;
                            n2 = -1;
                            break;
                        }
                        if (Character.isWhitespace(c2 = this.mySource.charAt(this.myCurrentIndex++))) {
                            n2 = 0;
                            break;
                        }
                        if (c2 == '\"') {
                            this.myLexemeType = 1;
                            this.myLexemeBeginIndex = this.myCurrentIndex;
                            n2 = 1;
                            break;
                        }
                        if (c2 == '(') {
                            ++n3;
                            n2 = 3;
                            break;
                        }
                        if (c2 == '/' || c2 == ';' || c2 == '=' || c2 == ')' || c2 == '<' || c2 == '>' || c2 == '@' || c2 == ',' || c2 == ':' || c2 == '\\' || c2 == '[' || c2 == ']' || c2 == '?') {
                            this.myLexemeType = 2;
                            this.myLexemeBeginIndex = this.myCurrentIndex - 1;
                            this.myLexemeEndIndex = this.myCurrentIndex;
                            n2 = -1;
                            break;
                        }
                        this.myLexemeType = 0;
                        this.myLexemeBeginIndex = this.myCurrentIndex - 1;
                        n2 = 5;
                        break;
                    }
                    case 1: {
                        char c2;
                        if (this.myCurrentIndex >= this.mySourceLength) {
                            this.myLexemeType = 4;
                            this.myLexemeBeginIndex = this.mySourceLength;
                            this.myLexemeEndIndex = this.mySourceLength;
                            n2 = -1;
                            break;
                        }
                        if ((c2 = this.mySource.charAt(this.myCurrentIndex++)) == '\"') {
                            this.myLexemeEndIndex = this.myCurrentIndex - 1;
                            n2 = -1;
                            break;
                        }
                        if (c2 == '\\') {
                            n2 = 2;
                            break;
                        }
                        n2 = 1;
                        break;
                    }
                    case 2: {
                        if (this.myCurrentIndex >= this.mySourceLength) {
                            this.myLexemeType = 4;
                            this.myLexemeBeginIndex = this.mySourceLength;
                            this.myLexemeEndIndex = this.mySourceLength;
                            n2 = -1;
                            break;
                        }
                        ++this.myCurrentIndex;
                        n2 = 1;
                        break;
                    }
                    case 3: {
                        char c2;
                        if (this.myCurrentIndex >= this.mySourceLength) {
                            this.myLexemeType = 4;
                            this.myLexemeBeginIndex = this.mySourceLength;
                            this.myLexemeEndIndex = this.mySourceLength;
                            n2 = -1;
                            break;
                        }
                        if ((c2 = this.mySource.charAt(this.myCurrentIndex++)) == '(') {
                            ++n3;
                            n2 = 3;
                            break;
                        }
                        if (c2 == ')') {
                            n2 = --n3 == 0 ? 0 : 3;
                            break;
                        }
                        if (c2 == '\\') {
                            n2 = 4;
                            break;
                        }
                        n2 = 3;
                        break;
                    }
                    case 4: {
                        if (this.myCurrentIndex >= this.mySourceLength) {
                            this.myLexemeType = 4;
                            this.myLexemeBeginIndex = this.mySourceLength;
                            this.myLexemeEndIndex = this.mySourceLength;
                            n2 = -1;
                            break;
                        }
                        ++this.myCurrentIndex;
                        n2 = 3;
                        break;
                    }
                    case 5: {
                        char c2;
                        if (this.myCurrentIndex >= this.mySourceLength) {
                            this.myLexemeEndIndex = this.myCurrentIndex;
                            n2 = -1;
                            break;
                        }
                        if (Character.isWhitespace(c2 = this.mySource.charAt(this.myCurrentIndex++))) {
                            this.myLexemeEndIndex = this.myCurrentIndex - 1;
                            n2 = -1;
                            break;
                        }
                        if (c2 == '\"' || c2 == '(' || c2 == '/' || c2 == ';' || c2 == '=' || c2 == ')' || c2 == '<' || c2 == '>' || c2 == '@' || c2 == ',' || c2 == ':' || c2 == '\\' || c2 == '[' || c2 == ']' || c2 == '?') {
                            this.myLexemeEndIndex = --this.myCurrentIndex;
                            n2 = -1;
                            break;
                        }
                        n2 = 5;
                    }
                }
            }
        }

        public String getLexeme() {
            return this.myLexemeBeginIndex >= this.mySourceLength ? null : this.mySource.substring(this.myLexemeBeginIndex, this.myLexemeEndIndex);
        }

        public LexicalAnalyzer(String string) {
            this.mySource = string;
            this.mySourceLength = string.length();
            this.myCurrentIndex = 0;
            this.nextLexeme();
        }
    }

    private class ParameterMap
    extends AbstractMap {
        private final MimeType this$0;

        public Set entrySet() {
            if (MimeType.access$200(this.this$0) == null) {
                MimeType.access$202(this.this$0, new ParameterMapEntrySet(this.this$0, null));
            }
            return MimeType.access$200(this.this$0);
        }

        private ParameterMap(MimeType mimeType) {
            this.this$0 = mimeType;
        }

        ParameterMap(MimeType mimeType, 1 var2_2) {
            this(mimeType);
        }
    }

    private class ParameterMapEntry
    implements Map.Entry {
        private int myIndex;
        private final MimeType this$0;

        public int hashCode() {
            return this.getKey().hashCode() ^ this.getValue().hashCode();
        }

        public Object getKey() {
            return MimeType.access$000(this.this$0)[this.myIndex];
        }

        public Object getValue() {
            return MimeType.access$000(this.this$0)[this.myIndex + 1];
        }

        public boolean equals(Object object) {
            return object != null && object instanceof Map.Entry && this.getKey().equals(((Map.Entry)object).getKey()) && this.getValue().equals(((Map.Entry)object).getValue());
        }

        public ParameterMapEntry(MimeType mimeType, int n2) {
            this.this$0 = mimeType;
            this.myIndex = n2;
        }

        public Object setValue(Object object) {
            throw new UnsupportedOperationException();
        }
    }

    private class ParameterMapEntrySet
    extends AbstractSet {
        private final MimeType this$0;

        public int size() {
            return (MimeType.access$000(this.this$0).length - 2) / 2;
        }

        public Iterator iterator() {
            return new ParameterMapEntrySetIterator(this.this$0, null);
        }

        private ParameterMapEntrySet(MimeType mimeType) {
            this.this$0 = mimeType;
        }

        ParameterMapEntrySet(MimeType mimeType, 1 var2_2) {
            this(mimeType);
        }
    }

    private class ParameterMapEntrySetIterator
    implements Iterator {
        private int myIndex;
        private final MimeType this$0;

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public boolean hasNext() {
            return this.myIndex < MimeType.access$000(this.this$0).length;
        }

        public Object next() {
            if (this.hasNext()) {
                ParameterMapEntry parameterMapEntry = new ParameterMapEntry(this.this$0, this.myIndex);
                this.myIndex += 2;
                return parameterMapEntry;
            }
            throw new NoSuchElementException();
        }

        private ParameterMapEntrySetIterator(MimeType mimeType) {
            this.this$0 = mimeType;
            this.myIndex = 2;
        }

        ParameterMapEntrySetIterator(MimeType mimeType, 1 var2_2) {
            this(mimeType);
        }
    }
}

